function [] = psquit()
%PSQUIT    Quit the Photoshop application.
%
%   Example:
%   psquit()
%
%   See also PSLAUNCH, PSJAVASCRIPT, PSCONFIG

%   Thomas Ruark, 2/24/2006
%   Copyright 2006 Adobe Systems Incorporated

% load our worker library
if ~libisloaded('psmatlab')
    if isunix
        loadlibrary('psmatlab.dylib', @psproto);
    else
        loadlibrary('psmatlab', @psproto);
    end
end

if isunix
    psjavascript('executeAction( charIDToTypeID( "quit" ), undefined, DialogModes.NO );');
else
	try
		calllib('psmatlab', 'psquit');
	catch
	    error('Photoshop appears to be unable to take commands.');
	end
end

unloadlibrary('psmatlab');

